<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>RSKone App - Field Visit Management System</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
    <style>
        .hero-section {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
            padding: 100px 0;
        }
        .feature-card {
            transition: transform 0.3s ease;
            border: none;
            box-shadow: 0 4px 6px rgba(0,0,0,0.1);
        }
        .feature-card:hover {
            transform: translateY(-5px);
        }
        .api-endpoint {
            background: #f8f9fa;
            border-left: 4px solid #007bff;
            padding: 15px;
            margin: 10px 0;
        }
        .status-badge {
            padding: 4px 8px;
            border-radius: 4px;
            font-size: 12px;
            font-weight: bold;
        }
        .status-active { background: #d4edda; color: #155724; }
        .status-pending { background: #fff3cd; color: #856404; }
    </style>
</head>
<body>
    <!-- Navigation -->
    <nav class="navbar navbar-expand-lg navbar-dark bg-dark">
        <div class="container">
            <a class="navbar-brand" href="#">
                <i class="fas fa-route me-2"></i>RSKone App
            </a>
            <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbarNav">
                <span class="navbar-toggler-icon"></span>
            </button>
            <div class="collapse navbar-collapse" id="navbarNav">
                <ul class="navbar-nav ms-auto">
                    <li class="nav-item">
                        <a class="nav-link" href="#features">Features</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" href="#api">API</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" href="#database">Database</a>
                    </li>
                </ul>
            </div>
        </div>
    </nav>

    <!-- Hero Section -->
    <section class="hero-section">
        <div class="container text-center">
            <h1 class="display-4 mb-4">
                <i class="fas fa-route me-3"></i>RSKone App
            </h1>
            <p class="lead mb-4">Field Visit Management System with Incentive, Collection, and Sales Process Tracking</p>
            <p class="mb-4">A robust backend API system designed for field sales and collection teams. Streamline field visits, track incentives, manage collections, and optimize sales workflow.</p>
            <div class="row justify-content-center">
                <div class="col-md-8">
                    <div class="alert alert-info">
                        <i class="fas fa-database me-2"></i>
                        <strong>Database:</strong> Connected to MyQual Database (rskworld_field)
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Features Section -->
    <section id="features" class="py-5">
        <div class="container">
            <h2 class="text-center mb-5">Core Features</h2>
            <div class="row">
                <div class="col-md-4 mb-4">
                    <div class="card feature-card h-100">
                        <div class="card-body text-center">
                            <i class="fas fa-calendar-alt fa-3x text-primary mb-3"></i>
                            <h5 class="card-title">Field Visit Scheduling</h5>
                            <p class="card-text">Schedule and manage field visits with real-time tracking and status updates.</p>
                        </div>
                    </div>
                </div>
                <div class="col-md-4 mb-4">
                    <div class="card feature-card h-100">
                        <div class="card-body text-center">
                            <i class="fas fa-map-marker-alt fa-3x text-success mb-3"></i>
                            <h5 class="card-title">Location Tracking</h5>
                            <p class="card-text">Real-time GPS location tracking for field agents with Google Maps integration.</p>
                        </div>
                    </div>
                </div>
                <div class="col-md-4 mb-4">
                    <div class="card feature-card h-100">
                        <div class="card-body text-center">
                            <i class="fas fa-calculator fa-3x text-warning mb-3"></i>
                            <h5 class="card-title">Incentive Calculation</h5>
                            <p class="card-text">Automated incentive calculation based on visits, completions, and collections.</p>
                        </div>
                    </div>
                </div>
                <div class="col-md-4 mb-4">
                    <div class="card feature-card h-100">
                        <div class="card-body text-center">
                            <i class="fas fa-money-bill-wave fa-3x text-info mb-3"></i>
                            <h5 class="card-title">Collection Management</h5>
                            <p class="card-text">Track and manage collections with multiple payment methods and reporting.</p>
                        </div>
                    </div>
                </div>
                <div class="col-md-4 mb-4">
                    <div class="card feature-card h-100">
                        <div class="card-body text-center">
                            <i class="fas fa-chart-line fa-3x text-danger mb-3"></i>
                            <h5 class="card-title">Sales Tracking</h5>
                            <p class="card-text">Comprehensive sales process tracking with performance analytics.</p>
                        </div>
                    </div>
                </div>
                <div class="col-md-4 mb-4">
                    <div class="card feature-card h-100">
                        <div class="card-body text-center">
                            <i class="fas fa-tachometer-alt fa-3x text-secondary mb-3"></i>
                            <h5 class="card-title">Reporting Dashboard</h5>
                            <p class="card-text">Real-time dashboard with performance metrics and target tracking.</p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- API Documentation Section -->
    <section id="api" class="py-5 bg-light">
        <div class="container">
            <h2 class="text-center mb-5">API Endpoints</h2>
            <div class="row">
                <div class="col-md-6">
                    <h4><i class="fas fa-user-shield me-2"></i>Authentication</h4>
                    <div class="api-endpoint">
                        <strong>POST</strong> /api/auth/login.php<br>
                        <small class="text-muted">User login with email and password</small>
                    </div>
                </div>
                <div class="col-md-6">
                    <h4><i class="fas fa-route me-2"></i>Field Visits</h4>
                    <div class="api-endpoint">
                        <strong>POST</strong> /api/visits/create.php<br>
                        <small class="text-muted">Create new field visit</small>
                    </div>
                    <div class="api-endpoint">
                        <strong>GET</strong> /api/visits/list.php<br>
                        <small class="text-muted">Get list of field visits</small>
                    </div>
                </div>
                <div class="col-md-6">
                    <h4><i class="fas fa-money-bill-wave me-2"></i>Collections</h4>
                    <div class="api-endpoint">
                        <strong>POST</strong> /api/collections/create.php<br>
                        <small class="text-muted">Record new collection</small>
                    </div>
                </div>
                <div class="col-md-6">
                    <h4><i class="fas fa-calculator me-2"></i>Incentives</h4>
                    <div class="api-endpoint">
                        <strong>GET</strong> /api/incentives/calculate.php<br>
                        <small class="text-muted">Calculate user incentives</small>
                    </div>
                </div>
                <div class="col-md-6">
                    <h4><i class="fas fa-map-marker-alt me-2"></i>Location</h4>
                    <div class="api-endpoint">
                        <strong>POST</strong> /api/location/track.php<br>
                        <small class="text-muted">Track user location</small>
                    </div>
                </div>
                <div class="col-md-6">
                    <h4><i class="fas fa-chart-bar me-2"></i>Reports</h4>
                    <div class="api-endpoint">
                        <strong>GET</strong> /api/reports/dashboard.php<br>
                        <small class="text-muted">Get dashboard data</small>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Database Section -->
    <section id="database" class="py-5">
        <div class="container">
            <h2 class="text-center mb-5">Database Schema</h2>
            <div class="row">
                <div class="col-md-8 mx-auto">
                    <div class="card">
                        <div class="card-header">
                            <h5><i class="fas fa-database me-2"></i>MyQual Database Tables</h5>
                        </div>
                        <div class="card-body">
                            <div class="row">
                                <div class="col-md-6">
                                    <ul class="list-unstyled">
                                        <li><i class="fas fa-table me-2"></i>users</li>
                                        <li><i class="fas fa-table me-2"></i>user_sessions</li>
                                        <li><i class="fas fa-table me-2"></i>field_visits</li>
                                        <li><i class="fas fa-table me-2"></i>collections</li>
                                    </ul>
                                </div>
                                <div class="col-md-6">
                                    <ul class="list-unstyled">
                                        <li><i class="fas fa-table me-2"></i>user_targets</li>
                                        <li><i class="fas fa-table me-2"></i>incentive_rates</li>
                                        <li><i class="fas fa-table me-2"></i>sales_records</li>
                                        <li><i class="fas fa-table me-2"></i>location_tracking</li>
                                    </ul>
                                </div>
                            </div>
                            <div class="mt-3">
                                <a href="database/schema.sql" class="btn btn-outline-primary">
                                    <i class="fas fa-download me-2"></i>Download Schema
                                </a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Footer -->
    <footer class="bg-dark text-white py-4">
        <div class="container text-center">
            <p class="mb-0">&copy; 2024 RSKone App - RSKWORLD.IN. All rights reserved.</p>
            <p class="mb-0">
                <i class="fas fa-code me-2"></i>Built with PHP, MySQL, and Bootstrap
            </p>
        </div>
    </footer>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
