<?php
/**
 * RSKone App - Database Connection Test
 * Test MyQual database connection
 */

header("Content-Type: application/json");
header("Access-Control-Allow-Origin: *");

require_once '../../config/database.php';

try {
    $database = new Database();
    $conn = $database->getConnection();
    
    if ($conn) {
        // Test basic query
        $stmt = $conn->query("SELECT VERSION() as version, NOW() as current_time");
        $result = $stmt->fetch(PDO::FETCH_ASSOC);
        
        // Check if tables exist
        $tables = ['users', 'field_visits', 'collections', 'user_targets'];
        $existing_tables = [];
        
        foreach ($tables as $table) {
            $checkStmt = $conn->query("SHOW TABLES LIKE '$table'");
            if ($checkStmt->rowCount() > 0) {
                $existing_tables[] = $table;
            }
        }
        
        http_response_code(200);
        echo json_encode([
            'success' => true,
            'message' => 'Database connection successful',
            'data' => [
                'database_version' => $result['version'],
                'current_time' => $result['current_time'],
                'connection_status' => 'connected',
                'existing_tables' => $existing_tables,
                'total_tables_found' => count($existing_tables)
            ]
        ]);
    } else {
        http_response_code(500);
        echo json_encode([
            'success' => false,
            'message' => 'Failed to establish database connection'
        ]);
    }
    
} catch (Exception $e) {
    http_response_code(500);
    echo json_encode([
        'success' => false,
        'message' => 'Database connection error: ' . $e->getMessage()
    ]);
}
?>
