<?php
/**
 * RSKone App - User Authentication API
 * Login endpoint for field sales team
 */

header("Content-Type: application/json");
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: POST");
header("Access-Control-Allow-Headers: Content-Type");

require_once '../../config/database.php';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $data = json_decode(file_get_contents("php://input"), true);
    
    $email = $data['email'] ?? '';
    $password = $data['password'] ?? '';
    
    if (empty($email) || empty($password)) {
        http_response_code(400);
        echo json_encode([
            'success' => false,
            'message' => 'Email and password are required'
        ]);
        exit;
    }
    
    try {
        $database = new Database();
        $db = $database->getConnection();
        
        $query = "SELECT id, name, email, role, status, created_at FROM users 
                  WHERE email = :email AND password = :password AND status = 'active'";
        
        $stmt = $db->prepare($query);
        $stmt->bindParam(':email', $email);
        $stmt->bindParam(':password', md5($password)); // Using MD5 for demo, use proper hashing in production
        
        $stmt->execute();
        
        if ($stmt->rowCount() > 0) {
            $user = $stmt->fetch(PDO::FETCH_ASSOC);
            
            // Generate session token
            $token = bin2hex(random_bytes(32));
            
            // Store token in database
            $tokenQuery = "INSERT INTO user_sessions (user_id, token, created_at, expires_at) 
                          VALUES (:user_id, :token, NOW(), DATE_ADD(NOW(), INTERVAL 24 HOUR))";
            $tokenStmt = $db->prepare($tokenQuery);
            $tokenStmt->bindParam(':user_id', $user['id']);
            $tokenStmt->bindParam(':token', $token);
            $tokenStmt->execute();
            
            http_response_code(200);
            echo json_encode([
                'success' => true,
                'message' => 'Login successful',
                'data' => [
                    'user' => $user,
                    'token' => $token
                ]
            ]);
        } else {
            http_response_code(401);
            echo json_encode([
                'success' => false,
                'message' => 'Invalid credentials'
            ]);
        }
        
    } catch (Exception $e) {
        http_response_code(500);
        echo json_encode([
            'success' => false,
            'message' => 'Server error: ' . $e->getMessage()
        ]);
    }
} else {
    http_response_code(405);
    echo json_encode([
        'success' => false,
        'message' => 'Method not allowed'
    ]);
}
?>
