# RSKone App - Field Visit Management System

A robust backend API system designed for field sales and collection teams. The system streamlines field visit processes, tracks incentives, manages collections, and optimizes sales workflow.

## 🚀 Features

- **Field Visit Scheduling** - Schedule and manage field visits with real-time tracking
- **Real-time Location Tracking** - GPS location tracking with Google Maps integration
- **Incentive Calculation** - Automated incentive calculation based on performance
- **Collection Management** - Track and manage collections with multiple payment methods
- **Sales Process Tracking** - Comprehensive sales process tracking with analytics
- **Reporting Dashboard** - Real-time dashboard with performance metrics

## 🛠️ Technologies

- **Backend**: PHP 7.4+
- **Database**: MySQL (MyQual Database)
- **Frontend**: Bootstrap 5, Font Awesome
- **API**: RESTful API with JSON responses

## 📋 Requirements

- PHP 7.4 or higher
- MySQL 5.7 or higher
- Web server (Apache/Nginx)
- PDO MySQL extension

## 🗄️ Database Setup

1. Import the database schema:
```sql
mysql -u rskworld_field -p rskworld_field < database/schema.sql
```

2. The database includes the following tables:
   - `users` - User management
   - `user_sessions` - Session management
   - `field_visits` - Field visit records
   - `collections` - Collection records
   - `user_targets` - User performance targets
   - `incentive_rates` - Incentive calculation rates
   - `sales_records` - Sales tracking
   - `location_tracking` - GPS location data

## 🔧 Configuration

Update the database configuration in `config/database.php`:

```php
private $host = "localhost";
private $db_name = "rskworld_field";
private $username = "rskworld_field";
private $password = "Sam@7076";
```

## 📡 API Endpoints

### Authentication
- `POST /api/auth/login.php` - User login

### Field Visits
- `POST /api/visits/create.php` - Create new field visit
- `GET /api/visits/list.php` - Get list of field visits

### Collections
- `POST /api/collections/create.php` - Record new collection

### Incentives
- `GET /api/incentives/calculate.php` - Calculate user incentives

### Location Tracking
- `POST /api/location/track.php` - Track user location

### Reports
- `GET /api/reports/dashboard.php` - Get dashboard data

### Testing
- `GET /api/test/connection.php` - Test database connection

## 🔐 Authentication

All API endpoints (except login) require an Authorization header with a valid token:

```
Authorization: your_token_here
```

## 📱 Usage Examples

### Login
```bash
curl -X POST http://your-domain.com/api/auth/login.php \
  -H "Content-Type: application/json" \
  -d '{"email":"user@example.com","password":"password123"}'
```

### Create Field Visit
```bash
curl -X POST http://your-domain.com/api/visits/create.php \
  -H "Content-Type: application/json" \
  -H "Authorization: your_token_here" \
  -d '{
    "customer_name":"John Doe",
    "customer_phone":"1234567890",
    "visit_date":"2024-01-15",
    "visit_time":"10:00:00",
    "location":"Customer Office",
    "purpose":"Sales Meeting"
  }'
```

### Track Location
```bash
curl -X POST http://your-domain.com/api/location/track.php \
  -H "Content-Type: application/json" \
  -H "Authorization: your_token_here" \
  -d '{
    "latitude":28.6139,
    "longitude":77.2090,
    "accuracy":10.5
  }'
```

## 🎯 Default Credentials

- **Admin User**: admin@rskone.com / admin123
- **Database**: rskworld_field / Sam@7076

## 📊 Database Schema

The system uses the following key relationships:
- Users can have multiple field visits
- Users can have multiple collections
- Users have monthly targets
- Location tracking is linked to users
- Incentives are calculated based on performance

## 🔄 API Response Format

All API responses follow this format:

```json
{
  "success": true|false,
  "message": "Response message",
  "data": {
    // Response data
  }
}
```

## 🚨 Error Handling

The API returns appropriate HTTP status codes:
- `200` - Success
- `201` - Created
- `400` - Bad Request
- `401` - Unauthorized
- `405` - Method Not Allowed
- `500` - Internal Server Error

## 📈 Performance Features

- Database indexing for optimal query performance
- Pagination support for large datasets
- Transaction support for data integrity
- Prepared statements for security

## 🔒 Security Features

- Token-based authentication
- SQL injection prevention
- Input validation
- CORS headers for cross-origin requests

## 📞 Support

For support and questions, contact:
- **Website**: RSKWORLD.IN
- **Email**: admin@rskone.com

## 📄 License

© 2024 RSKone App - RSKWORLD.IN. All rights reserved.
